<?php

require_once 'modules/admin/models/PluginCallback.php';
require_once 'modules/admin/models/StatusAliasGateway.php';
require_once 'modules/billing/models/class.gateway.plugin.php';
require_once 'modules/billing/models/Invoice_EventLog.php';
require_once 'modules/admin/models/Error_EventLog.php';

class PluginCryptomusCallback extends PluginCallback
{
    function processCallback()
    {
        $data = file_get_contents('php://input');
        $data = json_decode($data, true);
        CE_Lib::log(4, "** WEBHOOK DATA : " . json_encode($data));

        if (!$this->isSignValid($data)) {
            CE_Lib::log(4, "** Error from Cryptomus callback.");

            return;
        }

        $additionData = $data['additional_data'];
        $txid = $data['order_id'];
        $amount = $data['amount'];
        $status = $data['status'];
        $invoiceNumber = $additionData['invoice_id'];
        $cPlugin = new Plugin($invoiceNumber, "cryptomus", $this->user);
        $cPlugin->setAmount($amount);
        $cPlugin->setAction('charge');
        $cPlugin->setTransactionID($txid);

        if ($cPlugin->IsPaid() == 1) {
            return;
        }

        if ('paid' == $status || 'paid_over' == $status) {
            $transaction = "Cryptomus payment of $amount has been completed.";
            $cPlugin->PaymentAccepted($amount, $transaction, $invoiceNumber, $txid);
        } elseif ('fail' == $status || 'cancel' == $status || 'system_fail' == $status) {
            $transaction = 'Invalid Transaction';
            $cPlugin->PaymentRejected($transaction);
        }
    }

    function isSignValid(array &$data)
    {
        $apiKey = $this->settings->get('plugin_cryptomus_KEY Payment');
        $signature = $data['sign'];
        if (!$signature) {
            return false;
        }
        unset($data['sign']);

        $hash = md5(base64_encode(json_encode($data, JSON_UNESCAPED_UNICODE)) . $apiKey);
        if (!hash_equals($hash, $signature)) {
            return false;
        }

        return true;
    }
}
