<?php


require_once 'modules/billing/models/class.gateway.plugin.php';

class PluginCryptomus extends GatewayPlugin
{
    public function getVariables()
    {
        $variables = array(
            lang("Plugin Name") => array(
                "type" => "hidden",
                "description" => lang("How CE sees this plugin (not to be confused with the Signup Name)"),
                "value" => lang("Cryptomus")
            ),
            lang("Signup Name") => array (
                "type"          => "text",
                "description"   => lang("Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card."),
                "value"         => lang("Cryptomus")
            ),
            lang("Merchant ID") => array(
                "type" => "text",
                "description" => lang("Enter your Merchant ID from your business <a target='_blank' href='https://cryptomus.com'>cryptomus.com</a> account"),
                "value" => ""
            ),
            lang("KEY Payment") => array(
                "type" => "text",
                "description" => lang("Enter your secret Payment API Key from your business <a target='_blank' href='https://cryptomus.com'>cryptomus.com</a> account"),
                "value" => ""
            ),

        );
        return $variables;
    }

    public function credit($params)
    {
    }

    public function singlepayment($params, $test = false)
    {
        $merchantId = $this->settings->get('plugin_cryptomus_Merchant ID');
        $keyPayment = $this->settings->get('plugin_cryptomus_KEY Payment');
        $invoiceId = $params['invoiceNumber'];

        if (empty($keyPayment) || empty($merchantId)) {
            $this->showError($invoiceId, 'Merchant data in empty. Please contact us to see what went wrong.');
            return;
        }

        $data = array();
        $data['amount'] = $params['invoiceTotal'];
        $amountParam = (int)$params['invoiceTotal'];
        $data['currency'] = $params['userCurrency'];
        $data['order_id'] = "clientexec_id_{$amountParam}_" . $invoiceId;
        $data['url_callback'] = $params['clientExecURL'] . '/plugins/gateways/cryptomus/callback.php';
        $data['url_return'] = CE_Lib::getSoftwareURL() . "/index.php?fuse=billing&paid=1&controller=invoice&view=invoice&id=" . $invoiceId;
        $data['is_payment_multiple'] = true;
        $data['lifetime'] = (string)(3600 * 12);
        $data['additional_data'] = json_encode(array('invoice_id' => $invoiceId));

        $body = json_encode($data, JSON_UNESCAPED_UNICODE);

        $url = "https://api.cryptomus.com/v1/payment";

        $ch = curl_init();
        $headers = [
            'Accept: application/json',
            'Content-Type: application/json;charset=UTF-8',
            'Content-Length: ' . strlen($body),
            'merchant: ' . $merchantId,
            'sign: ' . md5(base64_encode($body) . $keyPayment)
        ];

        curl_setopt_array(
            $ch,
            [
                CURLOPT_URL => $url,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_POST => 1,
                CURLOPT_POSTFIELDS => $body,
                CURLOPT_RETURNTRANSFER => 1,
            ]
        );

        $response = curl_exec($ch);
        $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($response === false) {
            CE_Lib::log(4, "** Error encode Cryptomus create payment. " . curl_error($ch));
            CE_Lib::addErrorMessage($this->user->lang('Error Cryptomus create payment. Error #100.'));
            return;
        }

        if (false === empty($response)) {
            $json = json_decode($response, true);
            if (is_null($json)) {
                CE_Lib::log(4, "** Error encode Cryptomus create payment. " . json_last_error_msg());
                CE_Lib::addErrorMessage($this->user->lang('Error Cryptomus create payment. Error #101.'));
                return;
            }

            if ($responseCode !== 200 || (!is_null($json['state']) && $json['state'] != 0)) {
                if (!empty($json['message'])) {
                    CE_Lib::log(4, "** Error Cryptomus create payment. Message: " . $json['message']);
                    CE_Lib::addErrorMessage($this->user->lang('Error Cryptomus create payment. Error #102.'));
                    return;
                }

                if (!empty($json['errors'])) {
                    CE_Lib::log(4, "** Error Cryptomus create payment. Errors: " . json_encode($json['errors']));
                    CE_Lib::addErrorMessage($this->user->lang('Error Cryptomus create payment. Error #103.'));
                    return;
                }
            }

            if (empty($json['result']) || is_null($json['state']) || $json['state'] != 0) {
                CE_Lib::log(4, "** Error Cryptomus create payment. Empty result.");
                CE_Lib::addErrorMessage($this->user->lang('Error Cryptomus create payment. Error #104.'));
                return;
            }
        }

        header("location: " . $json['result']['url']);
        exit;
    }
}
